# For use with ribbon_maker.Rmd

`%notin%` <- Negate(`%in%`)


calculate_maxD <- function(sequence) {
  # First two residues back-exchange within experimental timescale.
  # Proline has no backbone amide H.
  sub_seq <- substr(sequence, 3, str_length(sequence))
  num_exchangeable <- str_length(sub_seq) - str_count(sub_seq, pattern = "P")
  return(num_exchangeable)
}


calculate_FD <- function(timepoint, centroid, cs, maxD, fracD2O) {
  # Calculate deuteration level for FD.
  # Percent deuteration = [(FDcen - NDcen) * cs ] / [maxD * fracDeut]
  # HDEXaminer centroid: `Exp Cent`
  ((centroid[timepoint == 'FD'] - centroid[timepoint == 'ND']) * cs ) / (maxD * fracD2O)
}


calculate_D <- function(timepoint, centroid, cs) {
  # Calculate deuteration levels for timepoints, normalized by ND and FD.
  # Percent deuteration = 100 * [(Dcen - NDcen) * cs ] / [(FDcen - NDcen) * cs]
  100 * ((centroid - centroid[timepoint == 'ND']) * cs) / 
    ((centroid[timepoint == 'FD'] - centroid[timepoint == 'ND']) * cs)
}


prepare_D_plot <- function(condition_now, df_D) {
  # Prepare df for deuteration plot
  # Peptide must include all tpts (drop_na).
  df_D_plot <- df_D %>% 
    select(protein:End, Charge, Confidence, peptide, percDeut) %>% 
    filter(condition == condition_now, timepoint %notin% c("ND", "FD")) %>% 
    group_by(peptide) %>% 
    pivot_wider(names_from = timepoint, values_from = c(Confidence, percDeut)) %>% 
    drop_na() %>%
    rowid_to_column(var='num_peptide') %>% 
    pivot_longer(
      cols =  matches("Confidence|percDeut"),
      names_to = c(".value", "timepoint"),
      names_pattern = "(.*)_(.*)",
      values_to = c("Confidence", "percDeut")
    )
  df_D_plot$timepoint <- as.numeric(df_D_plot$timepoint)
  
  df_D_plot <- df_D_plot %>% 
    left_join(df_tpts) %>% 
    mutate(
      bin_percDeut = cut(percDeut, breaks = df_LUT$percDeut_max_open, right = FALSE),
      plot_num = num_bars*(num_peptide - 1) + num_tpt,
      plot_num_2 = plot_num %% num_per_col
    )
  
  return(df_D_plot)
}

# LUT for deuteration
df_LUT <- df_LUT %>% 
  mutate(hex = rgb(R,G,B))
colors_now <- df_LUT$hex



